package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSubnetRequest(
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    cidrBlock: Optional[String] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    vpcId: VpcId,
    dryRun: Optional[Boolean] = Optional.Absent,
    ipv6Native: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSubnetRequest = {
    import CreateSubnetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
      .builder()
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSubnetRequest.ReadOnly =
    zio.aws.ec2.model.CreateSubnetRequest.wrap(buildAwsValue())
}
object CreateSubnetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSubnetRequest =
      zio.aws.ec2.model.CreateSubnetRequest(
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        cidrBlock.map(value => value),
        ipv6CidrBlock.map(value => value),
        outpostArn.map(value => value),
        vpcId,
        dryRun.map(value => value),
        ipv6Native.map(value => value)
      )
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def availabilityZone: Optional[String]
    def availabilityZoneId: Optional[String]
    def cidrBlock: Optional[String]
    def ipv6CidrBlock: Optional[String]
    def outpostArn: Optional[String]
    def vpcId: VpcId
    def dryRun: Optional[Boolean]
    def ipv6Native: Optional[Boolean]
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ) extends zio.aws.ec2.model.CreateSubnetRequest.ReadOnly {
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipv6Native: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Native())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ): zio.aws.ec2.model.CreateSubnetRequest.ReadOnly = new Wrapper(impl)
}
