package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkAclResponse(
    networkAcl: Optional[zio.aws.ec2.model.NetworkAcl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse = {
    import CreateNetworkAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse
      .builder()
      .optionallyWith(networkAcl.map(value => value.buildAwsValue()))(
        _.networkAcl
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly =
    zio.aws.ec2.model.CreateNetworkAclResponse.wrap(buildAwsValue())
}
object CreateNetworkAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkAclResponse =
      zio.aws.ec2.model
        .CreateNetworkAclResponse(networkAcl.map(value => value.asEditable))
    def networkAcl: Optional[zio.aws.ec2.model.NetworkAcl.ReadOnly]
    def getNetworkAcl
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkAcl.ReadOnly] =
      AwsError.unwrapOptionField("networkAcl", networkAcl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse
  ) extends zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly {
    override val networkAcl: Optional[zio.aws.ec2.model.NetworkAcl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkAcl())
        .map(value => zio.aws.ec2.model.NetworkAcl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse
  ): zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly = new Wrapper(impl)
}
