package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEgressOnlyInternetGatewayRequest(
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    vpcId: VpcId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest = {
    import CreateEgressOnlyInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest
      .wrap(buildAwsValue())
}
object CreateEgressOnlyInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest =
      zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest(
        clientToken.map(value => value),
        dryRun.map(value => value),
        vpcId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def vpcId: VpcId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest
  ) extends zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest
  ): zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
