package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AvailabilityZoneName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDefaultSubnetRequest(
    availabilityZone: AvailabilityZoneName,
    dryRun: Optional[Boolean] = Optional.Absent,
    ipv6Native: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest = {
    import CreateDefaultSubnetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
      .builder()
      .availabilityZone(
        AvailabilityZoneName.unwrap(availabilityZone): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly =
    zio.aws.ec2.model.CreateDefaultSubnetRequest.wrap(buildAwsValue())
}
object CreateDefaultSubnetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateDefaultSubnetRequest =
      zio.aws.ec2.model.CreateDefaultSubnetRequest(
        availabilityZone,
        dryRun.map(value => value),
        ipv6Native.map(value => value)
      )
    def availabilityZone: AvailabilityZoneName
    def dryRun: Optional[Boolean]
    def ipv6Native: Optional[Boolean]
    def getAvailabilityZone: ZIO[Any, Nothing, AvailabilityZoneName] =
      ZIO.succeed(availabilityZone)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ) extends zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly {
    override val availabilityZone: AvailabilityZoneName =
      zio.aws.ec2.model.primitives.AvailabilityZoneName(impl.availabilityZone())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipv6Native: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Native())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest
  ): zio.aws.ec2.model.CreateDefaultSubnetRequest.ReadOnly = new Wrapper(impl)
}
