package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfirmProductInstanceRequest(
    instanceId: InstanceId,
    productCode: String,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest = {
    import ConfirmProductInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .productCode(productCode: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly =
    zio.aws.ec2.model.ConfirmProductInstanceRequest.wrap(buildAwsValue())
}
object ConfirmProductInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConfirmProductInstanceRequest =
      zio.aws.ec2.model.ConfirmProductInstanceRequest(
        instanceId,
        productCode,
        dryRun.map(value => value)
      )
    def instanceId: InstanceId
    def productCode: String
    def dryRun: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getProductCode: ZIO[Any, Nothing, String] = ZIO.succeed(productCode)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ) extends zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val productCode: String = impl.productCode(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ): zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
