package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelBundleTaskRequest(
    bundleId: BundleId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest = {
    import CancelBundleTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
      .builder()
      .bundleId(BundleId.unwrap(bundleId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelBundleTaskRequest.wrap(buildAwsValue())
}
object CancelBundleTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelBundleTaskRequest =
      zio.aws.ec2.model
        .CancelBundleTaskRequest(bundleId, dryRun.map(value => value))
    def bundleId: BundleId
    def dryRun: Optional[Boolean]
    def getBundleId: ZIO[Any, Nothing, BundleId] = ZIO.succeed(bundleId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ) extends zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly {
    override val bundleId: BundleId =
      zio.aws.ec2.model.primitives.BundleId(impl.bundleId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ): zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly = new Wrapper(impl)
}
