package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthorizeSecurityGroupEgressRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    groupId: SecurityGroupId,
    ipPermissions: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    cidrIp: Optional[String] = Optional.Absent,
    fromPort: Optional[Integer] = Optional.Absent,
    ipProtocol: Optional[String] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    sourceSecurityGroupName: Optional[String] = Optional.Absent,
    sourceSecurityGroupOwnerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest = {
    import AuthorizeSecurityGroupEgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .groupId(SecurityGroupId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        sourceSecurityGroupName.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupName)
      .optionallyWith(
        sourceSecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupOwnerId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest.ReadOnly =
    zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest.wrap(buildAwsValue())
}
object AuthorizeSecurityGroupEgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest =
      zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest(
        dryRun.map(value => value),
        groupId,
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cidrIp.map(value => value),
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        toPort.map(value => value),
        sourceSecurityGroupName.map(value => value),
        sourceSecurityGroupOwnerId.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def groupId: SecurityGroupId
    def ipPermissions: Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def cidrIp: Optional[String]
    def fromPort: Optional[Integer]
    def ipProtocol: Optional[String]
    def toPort: Optional[Integer]
    def sourceSecurityGroupName: Optional[String]
    def sourceSecurityGroupOwnerId: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getGroupId: ZIO[Any, Nothing, SecurityGroupId] = ZIO.succeed(groupId)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getSourceSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceSecurityGroupName", sourceSecurityGroupName)
    def getSourceSecurityGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSecurityGroupOwnerId",
        sourceSecurityGroupOwnerId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest
  ) extends zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val groupId: SecurityGroupId =
      zio.aws.ec2.model.primitives.SecurityGroupId(impl.groupId())
    override val ipPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val cidrIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIp())
      .map(value => value: String)
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val sourceSecurityGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSecurityGroupName())
        .map(value => value: String)
    override val sourceSecurityGroupOwnerId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSecurityGroupOwnerId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest
  ): zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest.ReadOnly =
    new Wrapper(impl)
}
