package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VolumeId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVolumeRequest(
    device: String,
    instanceId: InstanceId,
    volumeId: VolumeId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVolumeRequest = {
    import AttachVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVolumeRequest
      .builder()
      .device(device: java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachVolumeRequest.ReadOnly =
    zio.aws.ec2.model.AttachVolumeRequest.wrap(buildAwsValue())
}
object AttachVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVolumeRequest =
      zio.aws.ec2.model.AttachVolumeRequest(
        device,
        instanceId,
        volumeId,
        dryRun.map(value => value)
      )
    def device: String
    def instanceId: InstanceId
    def volumeId: VolumeId
    def dryRun: Optional[Boolean]
    def getDevice: ZIO[Any, Nothing, String] = ZIO.succeed(device)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVolumeRequest
  ) extends zio.aws.ec2.model.AttachVolumeRequest.ReadOnly {
    override val device: String = impl.device(): String
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVolumeRequest
  ): zio.aws.ec2.model.AttachVolumeRequest.ReadOnly = new Wrapper(impl)
}
