package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, NetworkInterfaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateTrunkInterfaceRequest(
    branchInterfaceId: NetworkInterfaceId,
    trunkInterfaceId: NetworkInterfaceId,
    vlanId: Optional[Integer] = Optional.Absent,
    greKey: Optional[Integer] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest = {
    import AssociateTrunkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest
      .builder()
      .branchInterfaceId(
        NetworkInterfaceId.unwrap(branchInterfaceId): java.lang.String
      )
      .trunkInterfaceId(
        NetworkInterfaceId.unwrap(trunkInterfaceId): java.lang.String
      )
      .optionallyWith(vlanId.map(value => value: java.lang.Integer))(_.vlanId)
      .optionallyWith(greKey.map(value => value: java.lang.Integer))(_.greKey)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateTrunkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.AssociateTrunkInterfaceRequest.wrap(buildAwsValue())
}
object AssociateTrunkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateTrunkInterfaceRequest =
      zio.aws.ec2.model.AssociateTrunkInterfaceRequest(
        branchInterfaceId,
        trunkInterfaceId,
        vlanId.map(value => value),
        greKey.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def branchInterfaceId: NetworkInterfaceId
    def trunkInterfaceId: NetworkInterfaceId
    def vlanId: Optional[Integer]
    def greKey: Optional[Integer]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getBranchInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(branchInterfaceId)
    def getTrunkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(trunkInterfaceId)
    def getVlanId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vlanId", vlanId)
    def getGreKey: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("greKey", greKey)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest
  ) extends zio.aws.ec2.model.AssociateTrunkInterfaceRequest.ReadOnly {
    override val branchInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.branchInterfaceId())
    override val trunkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.trunkInterfaceId())
    override val vlanId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vlanId())
      .map(value => value: Integer)
    override val greKey: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.greKey())
      .map(value => value: Integer)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest
  ): zio.aws.ec2.model.AssociateTrunkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
