package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RouteGatewayId, SubnetId, RouteTableId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateRouteTableRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    routeTableId: RouteTableId,
    subnetId: Optional[SubnetId] = Optional.Absent,
    gatewayId: Optional[RouteGatewayId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest = {
    import AssociateRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        gatewayId.map(value => RouteGatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.AssociateRouteTableRequest.wrap(buildAwsValue())
}
object AssociateRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateRouteTableRequest =
      zio.aws.ec2.model.AssociateRouteTableRequest(
        dryRun.map(value => value),
        routeTableId,
        subnetId.map(value => value),
        gatewayId.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def routeTableId: RouteTableId
    def subnetId: Optional[SubnetId]
    def gatewayId: Optional[RouteGatewayId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getGatewayId: ZIO[Any, AwsError, RouteGatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest
  ) extends zio.aws.ec2.model.AssociateRouteTableRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val gatewayId: Optional[RouteGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.ec2.model.primitives.RouteGatewayId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest
  ): zio.aws.ec2.model.AssociateRouteTableRequest.ReadOnly = new Wrapper(impl)
}
