package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateInstanceEventWindowRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceEventWindowId: InstanceEventWindowId,
    associationTarget: zio.aws.ec2.model.InstanceEventWindowAssociationRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest = {
    import AssociateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .associationTarget(associationTarget.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.AssociateInstanceEventWindowRequest.wrap(buildAwsValue())
}
object AssociateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateInstanceEventWindowRequest =
      zio.aws.ec2.model.AssociateInstanceEventWindowRequest(
        dryRun.map(value => value),
        instanceEventWindowId,
        associationTarget.asEditable
      )
    def dryRun: Optional[Boolean]
    def instanceEventWindowId: InstanceEventWindowId
    def associationTarget
        : zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getAssociationTarget: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly
    ] = ZIO.succeed(associationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val associationTarget
        : zio.aws.ec2.model.InstanceEventWindowAssociationRequest.ReadOnly =
      zio.aws.ec2.model.InstanceEventWindowAssociationRequest
        .wrap(impl.associationTarget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest
  ): zio.aws.ec2.model.AssociateInstanceEventWindowRequest.ReadOnly =
    new Wrapper(impl)
}
