package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, DefaultingDhcpOptionsId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateDhcpOptionsRequest(
    dhcpOptionsId: DefaultingDhcpOptionsId,
    vpcId: VpcId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest = {
    import AssociateDhcpOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
      .builder()
      .dhcpOptionsId(
        DefaultingDhcpOptionsId.unwrap(dhcpOptionsId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly =
    zio.aws.ec2.model.AssociateDhcpOptionsRequest.wrap(buildAwsValue())
}
object AssociateDhcpOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateDhcpOptionsRequest =
      zio.aws.ec2.model.AssociateDhcpOptionsRequest(
        dhcpOptionsId,
        vpcId,
        dryRun.map(value => value)
      )
    def dhcpOptionsId: DefaultingDhcpOptionsId
    def vpcId: VpcId
    def dryRun: Optional[Boolean]
    def getDhcpOptionsId: ZIO[Any, Nothing, DefaultingDhcpOptionsId] =
      ZIO.succeed(dhcpOptionsId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ) extends zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly {
    override val dhcpOptionsId: DefaultingDhcpOptionsId =
      zio.aws.ec2.model.primitives.DefaultingDhcpOptionsId(impl.dhcpOptionsId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ): zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly = new Wrapper(impl)
}
