package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateClientVpnTargetNetworkResponse(
    associationId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.AssociationStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse = {
    import AssociateClientVpnTargetNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly =
    zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse
      .wrap(buildAwsValue())
}
object AssociateClientVpnTargetNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse =
      zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse(
        associationId.map(value => value),
        status.map(value => value.asEditable)
      )
    def associationId: Optional[String]
    def status: Optional[zio.aws.ec2.model.AssociationStatus.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse
  ) extends zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AssociationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse
  ): zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
