package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayPeeringAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest = {
    import AcceptTransitGatewayPeeringAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayPeeringAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest =
      zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest(
        transitGatewayAttachmentId,
        dryRun.map(value => value)
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def dryRun: Optional[Boolean]
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ) extends zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ): zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
