package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptReservedInstancesExchangeQuoteRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    reservedInstanceIds: Iterable[ReservationId],
    targetConfigurations: Optional[
      Iterable[zio.aws.ec2.model.TargetConfigurationRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest = {
    import AcceptReservedInstancesExchangeQuoteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .reservedInstanceIds(reservedInstanceIds.map { item =>
        ReservationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        targetConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest.ReadOnly =
    zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
      .wrap(buildAwsValue())
}
object AcceptReservedInstancesExchangeQuoteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest =
      zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest(
        dryRun.map(value => value),
        reservedInstanceIds,
        targetConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def reservedInstanceIds: List[ReservationId]
    def targetConfigurations
        : Optional[List[zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getReservedInstanceIds: ZIO[Any, Nothing, List[ReservationId]] =
      ZIO.succeed(reservedInstanceIds)
    def getTargetConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("targetConfigurations", targetConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
  ) extends zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val reservedInstanceIds: List[ReservationId] = impl
      .reservedInstanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.ReservationId(item)
      }
      .toList
    override val targetConfigurations: Optional[
      List[zio.aws.ec2.model.TargetConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TargetConfigurationRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
  ): zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest.ReadOnly =
    new Wrapper(impl)
}
