package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptAddressTransferRequest(
    address: String,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest = {
    import AcceptAddressTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest
      .builder()
      .address(address: java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceptAddressTransferRequest.ReadOnly =
    zio.aws.ec2.model.AcceptAddressTransferRequest.wrap(buildAwsValue())
}
object AcceptAddressTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptAddressTransferRequest =
      zio.aws.ec2.model.AcceptAddressTransferRequest(
        address,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def address: String
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getAddress: ZIO[Any, Nothing, String] = ZIO.succeed(address)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest
  ) extends zio.aws.ec2.model.AcceptAddressTransferRequest.ReadOnly {
    override val address: String = impl.address(): String
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest
  ): zio.aws.ec2.model.AcceptAddressTransferRequest.ReadOnly = new Wrapper(impl)
}
