package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WithdrawByoipCidrRequest(
    cidr: String,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest = {
    import WithdrawByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.WithdrawByoipCidrRequest.wrap(buildAwsValue())
}
object WithdrawByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.WithdrawByoipCidrRequest =
      zio.aws.ec2.model
        .WithdrawByoipCidrRequest(cidr, dryRun.map(value => value))
    def cidr: String
    def dryRun: Optional[Boolean]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ) extends zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ): zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
