package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CustomerGatewayConfiguration
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnConnection(
    customerGatewayConfiguration: Optional[CustomerGatewayConfiguration] =
      Optional.Absent,
    customerGatewayId: Optional[String] = Optional.Absent,
    category: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.VpnState] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.GatewayType] = Optional.Absent,
    vpnConnectionId: Optional[String] = Optional.Absent,
    vpnGatewayId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    coreNetworkArn: Optional[String] = Optional.Absent,
    coreNetworkAttachmentArn: Optional[String] = Optional.Absent,
    gatewayAssociationState: Optional[
      zio.aws.ec2.model.GatewayAssociationState
    ] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.VpnConnectionOptions] = Optional.Absent,
    routes: Optional[Iterable[zio.aws.ec2.model.VpnStaticRoute]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vgwTelemetry: Optional[Iterable[zio.aws.ec2.model.VgwTelemetry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnConnection = {
    import VpnConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnConnection
      .builder()
      .optionallyWith(
        customerGatewayConfiguration.map(value =>
          CustomerGatewayConfiguration.unwrap(value): java.lang.String
        )
      )(_.customerGatewayConfiguration)
      .optionallyWith(customerGatewayId.map(value => value: java.lang.String))(
        _.customerGatewayId
      )
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(vpnConnectionId.map(value => value: java.lang.String))(
        _.vpnConnectionId
      )
      .optionallyWith(vpnGatewayId.map(value => value: java.lang.String))(
        _.vpnGatewayId
      )
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(coreNetworkArn.map(value => value: java.lang.String))(
        _.coreNetworkArn
      )
      .optionallyWith(
        coreNetworkAttachmentArn.map(value => value: java.lang.String)
      )(_.coreNetworkAttachmentArn)
      .optionallyWith(gatewayAssociationState.map(value => value.unwrap))(
        _.gatewayAssociationState
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        vgwTelemetry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vgwTelemetry)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnection.ReadOnly =
    zio.aws.ec2.model.VpnConnection.wrap(buildAwsValue())
}
object VpnConnection {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpnConnection] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnection =
      zio.aws.ec2.model.VpnConnection(
        customerGatewayConfiguration.map(value => value),
        customerGatewayId.map(value => value),
        category.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        vpnConnectionId.map(value => value),
        vpnGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        coreNetworkArn.map(value => value),
        coreNetworkAttachmentArn.map(value => value),
        gatewayAssociationState.map(value => value),
        options.map(value => value.asEditable),
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vgwTelemetry.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGatewayConfiguration: Optional[CustomerGatewayConfiguration]
    def customerGatewayId: Optional[String]
    def category: Optional[String]
    def state: Optional[zio.aws.ec2.model.VpnState]
    def `type`: Optional[zio.aws.ec2.model.GatewayType]
    def vpnConnectionId: Optional[String]
    def vpnGatewayId: Optional[String]
    def transitGatewayId: Optional[String]
    def coreNetworkArn: Optional[String]
    def coreNetworkAttachmentArn: Optional[String]
    def gatewayAssociationState
        : Optional[zio.aws.ec2.model.GatewayAssociationState]
    def options: Optional[zio.aws.ec2.model.VpnConnectionOptions.ReadOnly]
    def routes: Optional[List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vgwTelemetry: Optional[List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]]
    def getCustomerGatewayConfiguration
        : ZIO[Any, AwsError, CustomerGatewayConfiguration] =
      AwsError.unwrapOptionField(
        "customerGatewayConfiguration",
        customerGatewayConfiguration
      )
    def getCustomerGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getCategory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("category", category)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpnState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.GatewayType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpnConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnConnectionId", vpnConnectionId)
    def getVpnGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCoreNetworkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getCoreNetworkAttachmentArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("coreNetworkAttachmentArn", coreNetworkAttachmentArn)
    def getGatewayAssociationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.GatewayAssociationState] =
      AwsError.unwrapOptionField(
        "gatewayAssociationState",
        gatewayAssociationState
      )
    def getOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnectionOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getRoutes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]] =
      AwsError.unwrapOptionField("routes", routes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVgwTelemetry
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]] =
      AwsError.unwrapOptionField("vgwTelemetry", vgwTelemetry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnection
  ) extends zio.aws.ec2.model.VpnConnection.ReadOnly {
    override val customerGatewayConfiguration
        : Optional[CustomerGatewayConfiguration] = zio.aws.core.internal
      .optionalFromNullable(impl.customerGatewayConfiguration())
      .map(value =>
        zio.aws.ec2.model.primitives.CustomerGatewayConfiguration(value)
      )
    override val customerGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerGatewayId())
      .map(value => value: String)
    override val category: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.VpnState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VpnState.wrap(value))
    override val `type`: Optional[zio.aws.ec2.model.GatewayType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.GatewayType.wrap(value))
    override val vpnConnectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnConnectionId())
      .map(value => value: String)
    override val vpnGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayId())
      .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val coreNetworkArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkArn())
      .map(value => value: String)
    override val coreNetworkAttachmentArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkAttachmentArn())
        .map(value => value: String)
    override val gatewayAssociationState
        : Optional[zio.aws.ec2.model.GatewayAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayAssociationState())
        .map(value => zio.aws.ec2.model.GatewayAssociationState.wrap(value))
    override val options
        : Optional[zio.aws.ec2.model.VpnConnectionOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.ec2.model.VpnConnectionOptions.wrap(value))
    override val routes
        : Optional[List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpnStaticRoute.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vgwTelemetry
        : Optional[List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vgwTelemetry())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VgwTelemetry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnection
  ): zio.aws.ec2.model.VpnConnection.ReadOnly = new Wrapper(impl)
}
