package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeStatusAction(
    code: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    eventId: Optional[String] = Optional.Absent,
    eventType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusAction = {
    import VolumeStatusAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusAction
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value: java.lang.String))(
        _.eventType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusAction.ReadOnly =
    zio.aws.ec2.model.VolumeStatusAction.wrap(buildAwsValue())
}
object VolumeStatusAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusAction =
      zio.aws.ec2.model.VolumeStatusAction(
        code.map(value => value),
        description.map(value => value),
        eventId.map(value => value),
        eventType.map(value => value)
      )
    def code: Optional[String]
    def description: Optional[String]
    def eventId: Optional[String]
    def eventType: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventType", eventType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ) extends zio.aws.ec2.model.VolumeStatusAction.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val eventId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: String)
    override val eventType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAction
  ): zio.aws.ec2.model.VolumeStatusAction.ReadOnly = new Wrapper(impl)
}
