package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogKinesisDataFirehoseDestinationOptions(
    enabled: Boolean,
    deliveryStream: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions = {
    import VerifiedAccessLogKinesisDataFirehoseDestinationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
      .wrap(buildAwsValue())
}
object VerifiedAccessLogKinesisDataFirehoseDestinationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions =
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions(
        enabled,
        deliveryStream.map(value => value)
      )
    def enabled: Boolean
    def deliveryStream: Optional[String]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getDeliveryStream: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
  ) extends zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val deliveryStream: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions
  ): zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions.ReadOnly =
    new Wrapper(impl)
}
