package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogKinesisDataFirehoseDestination(
    enabled: Optional[Boolean] = Optional.Absent,
    deliveryStatus: Optional[
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus
    ] = Optional.Absent,
    deliveryStream: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination = {
    import VerifiedAccessLogKinesisDataFirehoseDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(deliveryStatus.map(value => value.buildAwsValue()))(
        _.deliveryStatus
      )
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
      .wrap(buildAwsValue())
}
object VerifiedAccessLogKinesisDataFirehoseDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination =
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination(
        enabled.map(value => value),
        deliveryStatus.map(value => value.asEditable),
        deliveryStream.map(value => value)
      )
    def enabled: Optional[Boolean]
    def deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly]
    def deliveryStream: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDeliveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryStatus", deliveryStatus)
    def getDeliveryStream: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
  ) extends zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStatus())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.wrap(value)
        )
    override val deliveryStream: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
  ): zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly =
    new Wrapper(impl)
}
