package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessGroup(
    verifiedAccessGroupId: Optional[String] = Optional.Absent,
    verifiedAccessInstanceId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    owner: Optional[String] = Optional.Absent,
    verifiedAccessGroupArn: Optional[String] = Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    lastUpdatedTime: Optional[String] = Optional.Absent,
    deletionTime: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup = {
    import VerifiedAccessGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup
      .builder()
      .optionallyWith(
        verifiedAccessGroupId.map(value => value: java.lang.String)
      )(_.verifiedAccessGroupId)
      .optionallyWith(
        verifiedAccessInstanceId.map(value => value: java.lang.String)
      )(_.verifiedAccessInstanceId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(
        verifiedAccessGroupArn.map(value => value: java.lang.String)
      )(_.verifiedAccessGroupArn)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(lastUpdatedTime.map(value => value: java.lang.String))(
        _.lastUpdatedTime
      )
      .optionallyWith(deletionTime.map(value => value: java.lang.String))(
        _.deletionTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessGroup.wrap(buildAwsValue())
}
object VerifiedAccessGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessGroup =
      zio.aws.ec2.model.VerifiedAccessGroup(
        verifiedAccessGroupId.map(value => value),
        verifiedAccessInstanceId.map(value => value),
        description.map(value => value),
        owner.map(value => value),
        verifiedAccessGroupArn.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        deletionTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessGroupId: Optional[String]
    def verifiedAccessInstanceId: Optional[String]
    def description: Optional[String]
    def owner: Optional[String]
    def verifiedAccessGroupArn: Optional[String]
    def creationTime: Optional[String]
    def lastUpdatedTime: Optional[String]
    def deletionTime: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ]
    def getVerifiedAccessGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("verifiedAccessGroupId", verifiedAccessGroupId)
    def getVerifiedAccessInstanceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getVerifiedAccessGroupArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessGroupArn", verifiedAccessGroupArn)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getDeletionTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup
  ) extends zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly {
    override val verifiedAccessGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessGroupId())
      .map(value => value: String)
    override val verifiedAccessInstanceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val owner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: String)
    override val verifiedAccessGroupArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroupArn())
        .map(value => value: String)
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val lastUpdatedTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => value: String)
    override val deletionTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionTime())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup
  ): zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly = new Wrapper(impl)
}
