package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnsuccessfulItemError(
    code: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnsuccessfulItemError = {
    import UnsuccessfulItemError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnsuccessfulItemError
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly =
    zio.aws.ec2.model.UnsuccessfulItemError.wrap(buildAwsValue())
}
object UnsuccessfulItemError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnsuccessfulItemError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnsuccessfulItemError =
      zio.aws.ec2.model.UnsuccessfulItemError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[String]
    def message: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulItemError
  ) extends zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulItemError
  ): zio.aws.ec2.model.UnsuccessfulItemError.ReadOnly = new Wrapper(impl)
}
