package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateClientVpnConnectionsRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    connectionId: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest = {
    import TerminateClientVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.wrap(buildAwsValue())
}
object TerminateClientVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest =
      zio.aws.ec2.model.TerminateClientVpnConnectionsRequest(
        clientVpnEndpointId,
        connectionId.map(value => value),
        username.map(value => value),
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def connectionId: Optional[String]
    def username: Optional[String]
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ) extends zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val connectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest
  ): zio.aws.ec2.model.TerminateClientVpnConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
