package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetConfiguration(
    instanceCount: Optional[Integer] = Optional.Absent,
    offeringId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetConfiguration = {
    import TargetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetConfiguration
      .builder()
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetConfiguration.ReadOnly =
    zio.aws.ec2.model.TargetConfiguration.wrap(buildAwsValue())
}
object TargetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetConfiguration =
      zio.aws.ec2.model.TargetConfiguration(
        instanceCount.map(value => value),
        offeringId.map(value => value)
      )
    def instanceCount: Optional[Integer]
    def offeringId: Optional[String]
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringId", offeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ) extends zio.aws.ec2.model.TargetConfiguration.ReadOnly {
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val offeringId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ): zio.aws.ec2.model.TargetConfiguration.ReadOnly = new Wrapper(impl)
}
