package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartInstancesRequest(
    instanceIds: Iterable[InstanceId],
    additionalInfo: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartInstancesRequest = {
    import StartInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StartInstancesRequest.ReadOnly =
    zio.aws.ec2.model.StartInstancesRequest.wrap(buildAwsValue())
}
object StartInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StartInstancesRequest =
      zio.aws.ec2.model.StartInstancesRequest(
        instanceIds,
        additionalInfo.map(value => value),
        dryRun.map(value => value)
      )
    def instanceIds: List[InstanceId]
    def additionalInfo: Optional[String]
    def dryRun: Optional[Boolean]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ) extends zio.aws.ec2.model.StartInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ): zio.aws.ec2.model.StartInstancesRequest.ReadOnly = new Wrapper(impl)
}
