package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchTransitGatewayRoutesResponse(
    routes: Optional[Iterable[zio.aws.ec2.model.TransitGatewayRoute]] =
      Optional.Absent,
    additionalRoutesAvailable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse = {
    import SearchTransitGatewayRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse
      .builder()
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        additionalRoutesAvailable.map(value => value: java.lang.Boolean)
      )(_.additionalRoutesAvailable)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly =
    zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.wrap(buildAwsValue())
}
object SearchTransitGatewayRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SearchTransitGatewayRoutesResponse =
      zio.aws.ec2.model.SearchTransitGatewayRoutesResponse(
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        additionalRoutesAvailable.map(value => value)
      )
    def routes: Optional[List[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly]]
    def additionalRoutesAvailable: Optional[Boolean]
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
    def getAdditionalRoutesAvailable: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("additionalRoutesAvailable", additionalRoutesAvailable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse
  ) extends zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly {
    override val routes
        : Optional[List[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayRoute.wrap(item)
          }.toList
        )
    override val additionalRoutesAvailable: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalRoutesAvailable())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse
  ): zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
