package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotFromRecycleBinResponse(
    snapshotId: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    startTime: Optional[MillisecondDateTime] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.SnapshotState] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    sseType: Optional[zio.aws.ec2.model.SSEType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse = {
    import RestoreSnapshotFromRecycleBinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(sseType.map(value => value.unwrap))(_.sseType)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse
      .wrap(buildAwsValue())
}
object RestoreSnapshotFromRecycleBinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse =
      zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse(
        snapshotId.map(value => value),
        outpostArn.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        ownerId.map(value => value),
        progress.map(value => value),
        startTime.map(value => value),
        state.map(value => value),
        volumeId.map(value => value),
        volumeSize.map(value => value),
        sseType.map(value => value)
      )
    def snapshotId: Optional[String]
    def outpostArn: Optional[String]
    def description: Optional[String]
    def encrypted: Optional[Boolean]
    def ownerId: Optional[String]
    def progress: Optional[String]
    def startTime: Optional[MillisecondDateTime]
    def state: Optional[zio.aws.ec2.model.SnapshotState]
    def volumeId: Optional[String]
    def volumeSize: Optional[Integer]
    def sseType: Optional[zio.aws.ec2.model.SSEType]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getSseType: ZIO[Any, AwsError, zio.aws.ec2.model.SSEType] =
      AwsError.unwrapOptionField("sseType", sseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ) extends zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val startTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val state: Optional[zio.aws.ec2.model.SnapshotState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val sseType: Optional[zio.aws.ec2.model.SSEType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseType())
        .map(value => zio.aws.ec2.model.SSEType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ): zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly =
    new Wrapper(impl)
}
