package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReplacementStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.ReplacementStrategy
}
object ReplacementStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReplacementStrategy
  ): zio.aws.ec2.model.ReplacementStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.ReplacementStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReplacementStrategy.LAUNCH =>
      val r = launch
      r
    case software.amazon.awssdk.services.ec2.model.ReplacementStrategy.LAUNCH_BEFORE_TERMINATE =>
      val r = `launch-before-terminate`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.ReplacementStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object launch extends zio.aws.ec2.model.ReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.ReplacementStrategy.LAUNCH
  }
  case object `launch-before-terminate`
      extends zio.aws.ec2.model.ReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.ReplacementStrategy.LAUNCH_BEFORE_TERMINATE
  }
}
