package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SnapshotId,
  ImageId,
  ReplaceRootVolumeTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceRootVolumeTask(
    replaceRootVolumeTaskId: Optional[ReplaceRootVolumeTaskId] =
      Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    taskState: Optional[zio.aws.ec2.model.ReplaceRootVolumeTaskState] =
      Optional.Absent,
    startTime: Optional[String] = Optional.Absent,
    completeTime: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    deleteReplacedRootVolume: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask = {
    import ReplaceRootVolumeTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
      .builder()
      .optionallyWith(
        replaceRootVolumeTaskId.map(value =>
          ReplaceRootVolumeTaskId.unwrap(value): java.lang.String
        )
      )(_.replaceRootVolumeTaskId)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(taskState.map(value => value.unwrap))(_.taskState)
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(completeTime.map(value => value: java.lang.String))(
        _.completeTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        deleteReplacedRootVolume.map(value => value: java.lang.Boolean)
      )(_.deleteReplacedRootVolume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly =
    zio.aws.ec2.model.ReplaceRootVolumeTask.wrap(buildAwsValue())
}
object ReplaceRootVolumeTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRootVolumeTask =
      zio.aws.ec2.model.ReplaceRootVolumeTask(
        replaceRootVolumeTaskId.map(value => value),
        instanceId.map(value => value),
        taskState.map(value => value),
        startTime.map(value => value),
        completeTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        snapshotId.map(value => value),
        deleteReplacedRootVolume.map(value => value)
      )
    def replaceRootVolumeTaskId: Optional[ReplaceRootVolumeTaskId]
    def instanceId: Optional[String]
    def taskState: Optional[zio.aws.ec2.model.ReplaceRootVolumeTaskState]
    def startTime: Optional[String]
    def completeTime: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def imageId: Optional[ImageId]
    def snapshotId: Optional[SnapshotId]
    def deleteReplacedRootVolume: Optional[Boolean]
    def getReplaceRootVolumeTaskId
        : ZIO[Any, AwsError, ReplaceRootVolumeTaskId] = AwsError
      .unwrapOptionField("replaceRootVolumeTaskId", replaceRootVolumeTaskId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getTaskState
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReplaceRootVolumeTaskState] =
      AwsError.unwrapOptionField("taskState", taskState)
    def getStartTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompleteTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("completeTime", completeTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getDeleteReplacedRootVolume: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deleteReplacedRootVolume", deleteReplacedRootVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ) extends zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly {
    override val replaceRootVolumeTaskId: Optional[ReplaceRootVolumeTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceRootVolumeTaskId())
        .map(value =>
          zio.aws.ec2.model.primitives.ReplaceRootVolumeTaskId(value)
        )
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val taskState
        : Optional[zio.aws.ec2.model.ReplaceRootVolumeTaskState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskState())
        .map(value => zio.aws.ec2.model.ReplaceRootVolumeTaskState.wrap(value))
    override val startTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: String)
    override val completeTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.completeTime())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val deleteReplacedRootVolume: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteReplacedRootVolume())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask
  ): zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly = new Wrapper(impl)
}
