package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayMulticastGroupMembersRequest(
    transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId,
    groupIpAddress: Optional[String] = Optional.Absent,
    networkInterfaceIds: Iterable[NetworkInterfaceId],
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest = {
    import RegisterTransitGatewayMulticastGroupMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
      .builder()
      .transitGatewayMulticastDomainId(
        TransitGatewayMulticastDomainId.unwrap(
          transitGatewayMulticastDomainId
        ): java.lang.String
      )
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .networkInterfaceIds(networkInterfaceIds.map { item =>
        NetworkInterfaceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest.ReadOnly =
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayMulticastGroupMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest =
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest(
        transitGatewayMulticastDomainId,
        groupIpAddress.map(value => value),
        networkInterfaceIds,
        dryRun.map(value => value)
      )
    def transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId
    def groupIpAddress: Optional[String]
    def networkInterfaceIds: List[NetworkInterfaceId]
    def dryRun: Optional[Boolean]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, Nothing, TransitGatewayMulticastDomainId] =
      ZIO.succeed(transitGatewayMulticastDomainId)
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getNetworkInterfaceIds: ZIO[Any, Nothing, List[NetworkInterfaceId]] =
      ZIO.succeed(networkInterfaceIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
  ) extends zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : TransitGatewayMulticastDomainId = zio.aws.ec2.model.primitives
      .TransitGatewayMulticastDomainId(impl.transitGatewayMulticastDomainId())
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
    override val networkInterfaceIds: List[NetworkInterfaceId] = impl
      .networkInterfaceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
      }
      .toList
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
  ): zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest.ReadOnly =
    new Wrapper(impl)
}
