package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterInstanceEventNotificationAttributesResponse(
    instanceTagAttribute: Optional[
      zio.aws.ec2.model.InstanceTagNotificationAttribute
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse = {
    import RegisterInstanceEventNotificationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse
      .builder()
      .optionallyWith(instanceTagAttribute.map(value => value.buildAwsValue()))(
        _.instanceTagAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly =
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse
      .wrap(buildAwsValue())
}
object RegisterInstanceEventNotificationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse =
      zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse(
        instanceTagAttribute.map(value => value.asEditable)
      )
    def instanceTagAttribute
        : Optional[zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly]
    def getInstanceTagAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("instanceTagAttribute", instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse
  ) extends zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly {
    override val instanceTagAttribute: Optional[
      zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTagAttribute())
      .map(value =>
        zio.aws.ec2.model.InstanceTagNotificationAttribute.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse
  ): zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
