package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionIpamPoolCidrRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamPoolId: IpamPoolId,
    cidr: Optional[String] = Optional.Absent,
    cidrAuthorizationContext: Optional[
      zio.aws.ec2.model.IpamCidrAuthorizationContext
    ] = Optional.Absent,
    netmaskLength: Optional[Integer] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest = {
    import ProvisionIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        cidrAuthorizationContext.map(value => value.buildAwsValue())
      )(_.cidrAuthorizationContext)
      .optionallyWith(netmaskLength.map(value => value: java.lang.Integer))(
        _.netmaskLength
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.wrap(buildAwsValue())
}
object ProvisionIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest =
      zio.aws.ec2.model.ProvisionIpamPoolCidrRequest(
        dryRun.map(value => value),
        ipamPoolId,
        cidr.map(value => value),
        cidrAuthorizationContext.map(value => value.asEditable),
        netmaskLength.map(value => value),
        clientToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def ipamPoolId: IpamPoolId
    def cidr: Optional[String]
    def cidrAuthorizationContext
        : Optional[zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly]
    def netmaskLength: Optional[Integer]
    def clientToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getCidrAuthorizationContext: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cidrAuthorizationContext",
      cidrAuthorizationContext
    )
    def getNetmaskLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("netmaskLength", netmaskLength)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val cidrAuthorizationContext
        : Optional[zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrAuthorizationContext())
        .map(value =>
          zio.aws.ec2.model.IpamCidrAuthorizationContext.wrap(value)
        )
    override val netmaskLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.netmaskLength())
      .map(value => value: Integer)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ): zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly = new Wrapper(impl)
}
