package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PeeringTgwInfo(
    transitGatewayId: Optional[String] = Optional.Absent,
    coreNetworkId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PeeringTgwInfo = {
    import PeeringTgwInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
      .builder()
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(coreNetworkId.map(value => value: java.lang.String))(
        _.coreNetworkId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PeeringTgwInfo.ReadOnly =
    zio.aws.ec2.model.PeeringTgwInfo.wrap(buildAwsValue())
}
object PeeringTgwInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PeeringTgwInfo =
      zio.aws.ec2.model.PeeringTgwInfo(
        transitGatewayId.map(value => value),
        coreNetworkId.map(value => value),
        ownerId.map(value => value),
        region.map(value => value)
      )
    def transitGatewayId: Optional[String]
    def coreNetworkId: Optional[String]
    def ownerId: Optional[String]
    def region: Optional[String]
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCoreNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ) extends zio.aws.ec2.model.PeeringTgwInfo.ReadOnly {
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val coreNetworkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PeeringTgwInfo
  ): zio.aws.ec2.model.PeeringTgwInfo.ReadOnly = new Wrapper(impl)
}
