package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkAclEntry(
    cidrBlock: Optional[String] = Optional.Absent,
    egress: Optional[Boolean] = Optional.Absent,
    icmpTypeCode: Optional[zio.aws.ec2.model.IcmpTypeCode] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    portRange: Optional[zio.aws.ec2.model.PortRange] = Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    ruleAction: Optional[zio.aws.ec2.model.RuleAction] = Optional.Absent,
    ruleNumber: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkAclEntry = {
    import NetworkAclEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkAclEntry
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(egress.map(value => value: java.lang.Boolean))(_.egress)
      .optionallyWith(icmpTypeCode.map(value => value.buildAwsValue()))(
        _.icmpTypeCode
      )
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(ruleAction.map(value => value.unwrap))(_.ruleAction)
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkAclEntry.ReadOnly =
    zio.aws.ec2.model.NetworkAclEntry.wrap(buildAwsValue())
}
object NetworkAclEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkAclEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkAclEntry =
      zio.aws.ec2.model.NetworkAclEntry(
        cidrBlock.map(value => value),
        egress.map(value => value),
        icmpTypeCode.map(value => value.asEditable),
        ipv6CidrBlock.map(value => value),
        portRange.map(value => value.asEditable),
        protocol.map(value => value),
        ruleAction.map(value => value),
        ruleNumber.map(value => value)
      )
    def cidrBlock: Optional[String]
    def egress: Optional[Boolean]
    def icmpTypeCode: Optional[zio.aws.ec2.model.IcmpTypeCode.ReadOnly]
    def ipv6CidrBlock: Optional[String]
    def portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly]
    def protocol: Optional[String]
    def ruleAction: Optional[zio.aws.ec2.model.RuleAction]
    def ruleNumber: Optional[Integer]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("egress", egress)
    def getIcmpTypeCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.IcmpTypeCode.ReadOnly] =
      AwsError.unwrapOptionField("icmpTypeCode", icmpTypeCode)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getPortRange: ZIO[Any, AwsError, zio.aws.ec2.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getRuleAction: ZIO[Any, AwsError, zio.aws.ec2.model.RuleAction] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAclEntry
  ) extends zio.aws.ec2.model.NetworkAclEntry.ReadOnly {
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val egress: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.egress())
      .map(value => value: Boolean)
    override val icmpTypeCode
        : Optional[zio.aws.ec2.model.IcmpTypeCode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.icmpTypeCode())
        .map(value => zio.aws.ec2.model.IcmpTypeCode.wrap(value))
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value => zio.aws.ec2.model.PortRange.wrap(value))
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val ruleAction: Optional[zio.aws.ec2.model.RuleAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleAction())
        .map(value => zio.aws.ec2.model.RuleAction.wrap(value))
    override val ruleNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNumber())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAclEntry
  ): zio.aws.ec2.model.NetworkAclEntry.ReadOnly = new Wrapper(impl)
}
