package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelCertificateResponse(
    vpnConnection: Optional[zio.aws.ec2.model.VpnConnection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse = {
    import ModifyVpnTunnelCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.wrap(buildAwsValue())
}
object ModifyVpnTunnelCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse =
      zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Optional[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse
  ) extends zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly {
    override val vpnConnection
        : Optional[zio.aws.ec2.model.VpnConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnection())
        .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse
  ): zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
