package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServicePermissionsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceId: VpcEndpointServiceId,
    addAllowedPrincipals: Optional[Iterable[String]] = Optional.Absent,
    removeAllowedPrincipals: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest = {
    import ModifyVpcEndpointServicePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(
        addAllowedPrincipals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addAllowedPrincipals)
      .optionallyWith(
        removeAllowedPrincipals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeAllowedPrincipals)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServicePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest =
      zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest(
        dryRun.map(value => value),
        serviceId,
        addAllowedPrincipals.map(value => value),
        removeAllowedPrincipals.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def serviceId: VpcEndpointServiceId
    def addAllowedPrincipals: Optional[List[String]]
    def removeAllowedPrincipals: Optional[List[String]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getAddAllowedPrincipals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("addAllowedPrincipals", addAllowedPrincipals)
    def getRemoveAllowedPrincipals: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("removeAllowedPrincipals", removeAllowedPrincipals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val addAllowedPrincipals: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addAllowedPrincipals())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val removeAllowedPrincipals: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeAllowedPrincipals())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
