package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamPoolResponse(
    ipamPool: Optional[zio.aws.ec2.model.IpamPool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse = {
    import ModifyIpamPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse
      .builder()
      .optionallyWith(ipamPool.map(value => value.buildAwsValue()))(_.ipamPool)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly =
    zio.aws.ec2.model.ModifyIpamPoolResponse.wrap(buildAwsValue())
}
object ModifyIpamPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamPoolResponse = zio.aws.ec2.model
      .ModifyIpamPoolResponse(ipamPool.map(value => value.asEditable))
    def ipamPool: Optional[zio.aws.ec2.model.IpamPool.ReadOnly]
    def getIpamPool: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
      AwsError.unwrapOptionField("ipamPool", ipamPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse
  ) extends zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly {
    override val ipamPool: Optional[zio.aws.ec2.model.IpamPool.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPool())
        .map(value => zio.aws.ec2.model.IpamPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse
  ): zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly = new Wrapper(impl)
}
