package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  IpamId,
  IpamResourceDiscoveryId,
  IpamResourceDiscoveryAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamResourceDiscoveryAssociation(
    ownerId: Optional[String] = Optional.Absent,
    ipamResourceDiscoveryAssociationId: Optional[
      IpamResourceDiscoveryAssociationId
    ] = Optional.Absent,
    ipamResourceDiscoveryAssociationArn: Optional[String] = Optional.Absent,
    ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      Optional.Absent,
    ipamId: Optional[IpamId] = Optional.Absent,
    ipamArn: Optional[ResourceArn] = Optional.Absent,
    ipamRegion: Optional[String] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    resourceDiscoveryStatus: Optional[
      zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus
    ] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamResourceDiscoveryAssociationState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation = {
    import IpamResourceDiscoveryAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamResourceDiscoveryAssociationId.map(value =>
          IpamResourceDiscoveryAssociationId.unwrap(value): java.lang.String
        )
      )(_.ipamResourceDiscoveryAssociationId)
      .optionallyWith(
        ipamResourceDiscoveryAssociationArn.map(value =>
          value: java.lang.String
        )
      )(_.ipamResourceDiscoveryAssociationArn)
      .optionallyWith(
        ipamResourceDiscoveryId.map(value =>
          IpamResourceDiscoveryId.unwrap(value): java.lang.String
        )
      )(_.ipamResourceDiscoveryId)
      .optionallyWith(
        ipamId.map(value => IpamId.unwrap(value): java.lang.String)
      )(_.ipamId)
      .optionallyWith(
        ipamArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamArn)
      .optionallyWith(ipamRegion.map(value => value: java.lang.String))(
        _.ipamRegion
      )
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(resourceDiscoveryStatus.map(value => value.unwrap))(
        _.resourceDiscoveryStatus
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly =
    zio.aws.ec2.model.IpamResourceDiscoveryAssociation.wrap(buildAwsValue())
}
object IpamResourceDiscoveryAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamResourceDiscoveryAssociation =
      zio.aws.ec2.model.IpamResourceDiscoveryAssociation(
        ownerId.map(value => value),
        ipamResourceDiscoveryAssociationId.map(value => value),
        ipamResourceDiscoveryAssociationArn.map(value => value),
        ipamResourceDiscoveryId.map(value => value),
        ipamId.map(value => value),
        ipamArn.map(value => value),
        ipamRegion.map(value => value),
        isDefault.map(value => value),
        resourceDiscoveryStatus.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ownerId: Optional[String]
    def ipamResourceDiscoveryAssociationId
        : Optional[IpamResourceDiscoveryAssociationId]
    def ipamResourceDiscoveryAssociationArn: Optional[String]
    def ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId]
    def ipamId: Optional[IpamId]
    def ipamArn: Optional[ResourceArn]
    def ipamRegion: Optional[String]
    def isDefault: Optional[Boolean]
    def resourceDiscoveryStatus
        : Optional[zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus]
    def state: Optional[zio.aws.ec2.model.IpamResourceDiscoveryAssociationState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamResourceDiscoveryAssociationId
        : ZIO[Any, AwsError, IpamResourceDiscoveryAssociationId] =
      AwsError.unwrapOptionField(
        "ipamResourceDiscoveryAssociationId",
        ipamResourceDiscoveryAssociationId
      )
    def getIpamResourceDiscoveryAssociationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ipamResourceDiscoveryAssociationArn",
        ipamResourceDiscoveryAssociationArn
      )
    def getIpamResourceDiscoveryId
        : ZIO[Any, AwsError, IpamResourceDiscoveryId] = AwsError
      .unwrapOptionField("ipamResourceDiscoveryId", ipamResourceDiscoveryId)
    def getIpamId: ZIO[Any, AwsError, IpamId] =
      AwsError.unwrapOptionField("ipamId", ipamId)
    def getIpamArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamArn", ipamArn)
    def getIpamRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamRegion", ipamRegion)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getResourceDiscoveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus
    ] = AwsError.unwrapOptionField(
      "resourceDiscoveryStatus",
      resourceDiscoveryStatus
    )
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamResourceDiscoveryAssociationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation
  ) extends zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ipamResourceDiscoveryAssociationId
        : Optional[IpamResourceDiscoveryAssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamResourceDiscoveryAssociationId())
      .map(value =>
        zio.aws.ec2.model.primitives.IpamResourceDiscoveryAssociationId(value)
      )
    override val ipamResourceDiscoveryAssociationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryAssociationArn())
        .map(value => value: String)
    override val ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryId())
        .map(value =>
          zio.aws.ec2.model.primitives.IpamResourceDiscoveryId(value)
        )
    override val ipamId: Optional[IpamId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamId())
      .map(value => zio.aws.ec2.model.primitives.IpamId(value))
    override val ipamArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamRegion())
      .map(value => value: String)
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val resourceDiscoveryStatus
        : Optional[zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDiscoveryStatus())
        .map(value =>
          zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus.wrap(value)
        )
    override val state
        : Optional[zio.aws.ec2.model.IpamResourceDiscoveryAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.IpamResourceDiscoveryAssociationState.wrap(value)
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation
  ): zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly = new Wrapper(
    impl
  )
}
