package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceBootModeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceBootModeValues
}
object InstanceBootModeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceBootModeValues
  ): zio.aws.ec2.model.InstanceBootModeValues = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.LEGACY_BIOS =>
      val r = `legacy-bios`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.UEFI =>
      val r = uefi
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceBootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceBootModeValues =
      software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object `legacy-bios` extends zio.aws.ec2.model.InstanceBootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceBootModeValues =
      software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.LEGACY_BIOS
  }
  case object uefi extends zio.aws.ec2.model.InstanceBootModeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceBootModeValues =
      software.amazon.awssdk.services.ec2.model.InstanceBootModeValues.UEFI
  }
}
