package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  SecurityGroupName,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportInstanceLaunchSpecification(
    additionalInfo: Optional[String] = Optional.Absent,
    architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      Optional.Absent,
    groupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    groupNames: Optional[Iterable[SecurityGroupName]] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.ShutdownBehavior
    ] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    monitoring: Optional[Boolean] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.Placement] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    userData: Optional[zio.aws.ec2.model.UserData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification = {
    import ImportInstanceLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
      .builder()
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(monitoring.map(value => value: java.lang.Boolean))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.ImportInstanceLaunchSpecification.wrap(buildAwsValue())
}
object ImportInstanceLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceLaunchSpecification =
      zio.aws.ec2.model.ImportInstanceLaunchSpecification(
        additionalInfo.map(value => value),
        architecture.map(value => value),
        groupIds.map(value => value),
        groupNames.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        instanceType.map(value => value),
        monitoring.map(value => value),
        placement.map(value => value.asEditable),
        privateIpAddress.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value.asEditable)
      )
    def additionalInfo: Optional[String]
    def architecture: Optional[zio.aws.ec2.model.ArchitectureValues]
    def groupIds: Optional[List[SecurityGroupId]]
    def groupNames: Optional[List[SecurityGroupName]]
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def monitoring: Optional[Boolean]
    def placement: Optional[zio.aws.ec2.model.Placement.ReadOnly]
    def privateIpAddress: Optional[String]
    def subnetId: Optional[SubnetId]
    def userData: Optional[zio.aws.ec2.model.UserData.ReadOnly]
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
    def getGroupNames: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMonitoring: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, zio.aws.ec2.model.UserData.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ) extends zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly {
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
    override val architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val groupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val groupNames: Optional[List[SecurityGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupName(item)
          }.toList
        )
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val monitoring: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoring())
      .map(value => value: Boolean)
    override val placement: Optional[zio.aws.ec2.model.Placement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Optional[zio.aws.ec2.model.UserData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userData())
        .map(value => zio.aws.ec2.model.UserData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ): zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly = new Wrapper(
    impl
  )
}
