package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IamInstanceProfile(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IamInstanceProfile = {
    import IamInstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IamInstanceProfile
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IamInstanceProfile.ReadOnly =
    zio.aws.ec2.model.IamInstanceProfile.wrap(buildAwsValue())
}
object IamInstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IamInstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IamInstanceProfile = zio.aws.ec2.model
      .IamInstanceProfile(arn.map(value => value), id.map(value => value))
    def arn: Optional[String]
    def id: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfile
  ) extends zio.aws.ec2.model.IamInstanceProfile.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfile
  ): zio.aws.ec2.model.IamInstanceProfile.ReadOnly = new Wrapper(impl)
}
