package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVerifiedAccessEndpointPolicyRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest = {
    import GetVerifiedAccessEndpointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly =
    zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest
      .wrap(buildAwsValue())
}
object GetVerifiedAccessEndpointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest =
      zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest(
        verifiedAccessEndpointId,
        dryRun.map(value => value)
      )
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def dryRun: Optional[Boolean]
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ) extends zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ): zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
