package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetImageBlockPublicAccessStateRequest(
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest = {
    import GetImageBlockPublicAccessStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetImageBlockPublicAccessStateRequest.ReadOnly =
    zio.aws.ec2.model.GetImageBlockPublicAccessStateRequest
      .wrap(buildAwsValue())
}
object GetImageBlockPublicAccessStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetImageBlockPublicAccessStateRequest =
      zio.aws.ec2.model
        .GetImageBlockPublicAccessStateRequest(dryRun.map(value => value))
    def dryRun: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest
  ) extends zio.aws.ec2.model.GetImageBlockPublicAccessStateRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest
  ): zio.aws.ec2.model.GetImageBlockPublicAccessStateRequest.ReadOnly =
    new Wrapper(impl)
}
