package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetOnDemandAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy
}
object FleetOnDemandAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy
  ): zio.aws.ec2.model.FleetOnDemandAllocationStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.LOWEST_PRICE =>
      val r = `lowest-price`
      r
    case software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.PRIORITIZED =>
      val r = prioritized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetOnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `lowest-price`
      extends zio.aws.ec2.model.FleetOnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.LOWEST_PRICE
  }
  case object prioritized
      extends zio.aws.ec2.model.FleetOnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy.PRIORITIZED
  }
}
