package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FederatedAuthentication(
    samlProviderArn: Optional[String] = Optional.Absent,
    selfServiceSamlProviderArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FederatedAuthentication = {
    import FederatedAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FederatedAuthentication
      .builder()
      .optionallyWith(samlProviderArn.map(value => value: java.lang.String))(
        _.samlProviderArn
      )
      .optionallyWith(
        selfServiceSamlProviderArn.map(value => value: java.lang.String)
      )(_.selfServiceSamlProviderArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FederatedAuthentication.ReadOnly =
    zio.aws.ec2.model.FederatedAuthentication.wrap(buildAwsValue())
}
object FederatedAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FederatedAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FederatedAuthentication =
      zio.aws.ec2.model.FederatedAuthentication(
        samlProviderArn.map(value => value),
        selfServiceSamlProviderArn.map(value => value)
      )
    def samlProviderArn: Optional[String]
    def selfServiceSamlProviderArn: Optional[String]
    def getSamlProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("samlProviderArn", samlProviderArn)
    def getSelfServiceSamlProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "selfServiceSamlProviderArn",
        selfServiceSamlProviderArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FederatedAuthentication
  ) extends zio.aws.ec2.model.FederatedAuthentication.ReadOnly {
    override val samlProviderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.samlProviderArn())
      .map(value => value: String)
    override val selfServiceSamlProviderArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfServiceSamlProviderArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FederatedAuthentication
  ): zio.aws.ec2.model.FederatedAuthentication.ReadOnly = new Wrapper(impl)
}
