package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportClientVpnClientConfigurationRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest = {
    import ExportClientVpnClientConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest
      .wrap(buildAwsValue())
}
object ExportClientVpnClientConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest =
      zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest(
        clientVpnEndpointId,
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ) extends zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest
  ): zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
