package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableAddressTransferResponse(
    addressTransfer: Optional[zio.aws.ec2.model.AddressTransfer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse = {
    import EnableAddressTransferResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse
      .builder()
      .optionallyWith(addressTransfer.map(value => value.buildAwsValue()))(
        _.addressTransfer
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableAddressTransferResponse.ReadOnly =
    zio.aws.ec2.model.EnableAddressTransferResponse.wrap(buildAwsValue())
}
object EnableAddressTransferResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableAddressTransferResponse =
      zio.aws.ec2.model.EnableAddressTransferResponse(
        addressTransfer.map(value => value.asEditable)
      )
    def addressTransfer: Optional[zio.aws.ec2.model.AddressTransfer.ReadOnly]
    def getAddressTransfer
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressTransfer.ReadOnly] =
      AwsError.unwrapOptionField("addressTransfer", addressTransfer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse
  ) extends zio.aws.ec2.model.EnableAddressTransferResponse.ReadOnly {
    override val addressTransfer
        : Optional[zio.aws.ec2.model.AddressTransfer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressTransfer())
        .map(value => zio.aws.ec2.model.AddressTransfer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse
  ): zio.aws.ec2.model.EnableAddressTransferResponse.ReadOnly = new Wrapper(
    impl
  )
}
