package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ElasticGpuStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.ElasticGpuStatus
}
object ElasticGpuStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ElasticGpuStatus
  ): zio.aws.ec2.model.ElasticGpuStatus = value match {
    case software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.IMPAIRED =>
      val r = IMPAIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ElasticGpuStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ElasticGpuStatus =
      software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends zio.aws.ec2.model.ElasticGpuStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ElasticGpuStatus =
      software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.OK
  }
  case object IMPAIRED extends zio.aws.ec2.model.ElasticGpuStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ElasticGpuStatus =
      software.amazon.awssdk.services.ec2.model.ElasticGpuStatus.IMPAIRED
  }
}
