package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrunkInterfaceAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateTrunkInterfaceRequest(
    associationId: TrunkInterfaceAssociationId,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest = {
    import DisassociateTrunkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest
      .builder()
      .associationId(
        TrunkInterfaceAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateTrunkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateTrunkInterfaceRequest.wrap(buildAwsValue())
}
object DisassociateTrunkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateTrunkInterfaceRequest =
      zio.aws.ec2.model.DisassociateTrunkInterfaceRequest(
        associationId,
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def associationId: TrunkInterfaceAssociationId
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getAssociationId: ZIO[Any, Nothing, TrunkInterfaceAssociationId] =
      ZIO.succeed(associationId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest
  ) extends zio.aws.ec2.model.DisassociateTrunkInterfaceRequest.ReadOnly {
    override val associationId: TrunkInterfaceAssociationId =
      zio.aws.ec2.model.primitives
        .TrunkInterfaceAssociationId(impl.associationId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest
  ): zio.aws.ec2.model.DisassociateTrunkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
